#ifndef CRYS_FLOW_ERROR_H
#define CRYS_FLOW_ERROR_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CRYS_error.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object % CRYS_DES_error.h    : %
   *  State           :  %state%
   *  Creation date   :  Sun Nov 21 11:07:08 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This module containes the definitions of the CRYS AES errors.
   *
   *  \version CRYS_DES_error.h#1:incl:1
   *  \author adams
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */




/************************ Defines ******************************/

/* CRYS_FLOW_MODULE_ERROR_BASE - 0x00F01400 */


/* The illegal null pointer input argument */
#define CRYS_FLOW_ARG_NULL_PTR_ERROR                     (CRYS_FLOW_MODULE_ERROR_BASE + 0x0UL)

/* not enough memory allovated in the input paramater */
#define CRYS_FLOW_UNSUFFICIENT_MEMORY_ALLOC_ERROR        (CRYS_FLOW_MODULE_ERROR_BASE + 0x1UL)

/* total out size not equal total in size */
#define CRYS_FLOW_TOTAL_INSIZE_NOT_EQUAL_OUTSIZE_ERROR   (CRYS_FLOW_MODULE_ERROR_BASE + 0x2UL)

/* hash operation buffer size in not modulu 64 */
#define CRYS_FLOW_HASH_OP_BUFF_NOT_MOD_64_ERROR          (CRYS_FLOW_MODULE_ERROR_BASE + 0x3UL)

/* static buffer in/out sizes are not equal */
#define CRYS_FLOW_STATIC_INBUFF_SIZES_NOT_EQUAL_ERROR    (CRYS_FLOW_MODULE_ERROR_BASE + 0x4UL)
#define CRYS_FLOW_STATIC_OUTBUFF_SIZES_NOT_EQUAL_ERROR   (CRYS_FLOW_MODULE_ERROR_BASE + 0x5UL)

/* hash operation buffer size in not modulu 128 */
#define CRYS_FLOW_HASH_OP_BUFF_NOT_MOD_128_ERROR         (CRYS_FLOW_MODULE_ERROR_BASE + 0x6UL)

/* RC4 operation buffer size in not modulu 8 */
#define CRYS_FLOW_RC4_OP_IN_BUFF_NOT_MOD_8_ERROR         (CRYS_FLOW_MODULE_ERROR_BASE + 0x7UL)
#define CRYS_FLOW_RC4_OP_OUT_BUFF_NOT_MOD_8_ERROR        (CRYS_FLOW_MODULE_ERROR_BASE + 0x8UL)

/* AES operation buffer size in not modulu 16 */
#define CRYS_FLOW_AES_OP_IN_BUFF_NOT_MOD_16_ERROR        (CRYS_FLOW_MODULE_ERROR_BASE + 0x9UL)
#define CRYS_FLOW_AES_OP_OUT_BUFF_NOT_MOD_16_ERROR       (CRYS_FLOW_MODULE_ERROR_BASE + 0xaUL)

/* initialization input/output buffers are NULL */
#define CRYS_FLOW_INPUT_BUFFER_IS_NULL_ERROR             (CRYS_FLOW_MODULE_ERROR_BASE + 0xbUL)
#define CRYS_FLOW_OUTPUT_BUFFER_IS_NULL_ERROR            (CRYS_FLOW_MODULE_ERROR_BASE + 0xcUL)

#define CRYS_FLOW_ADD_BUFFER_NOT_DYNAMIC_ERROR           (CRYS_FLOW_MODULE_ERROR_BASE + 0xdUL)

/* finish operation input validity check */
#define CRYS_FLOW_FINISH_NO_ACTIVE_FLOWID_ERROR          (CRYS_FLOW_MODULE_ERROR_BASE + 0xeUL)

/* terminate operation input validity check */
#define CRYS_FLOW_TERMINATE_NO_ACTIVE_FLOWID_ERROR       (CRYS_FLOW_MODULE_ERROR_BASE + 0x10UL)

/* get result operation input validity check */
#define CRYS_FLOW_GETRESUALT_NO_ACTIVE_FLOWID_ERROR      (CRYS_FLOW_MODULE_ERROR_BASE + 0x11UL)

/* illegal type of the flow (not static and not dynamic) */
#define CRYS_FLOW_ILLEGALTYPE_ERROR                      (CRYS_FLOW_MODULE_ERROR_BASE + 0x12UL)

/* DES operation buffer size in not modulu 8 */
#define CRYS_FLOW_DES_OP_IN_BUFF_NOT_MOD_8_ERROR         (CRYS_FLOW_MODULE_ERROR_BASE + 0x13UL)
#define CRYS_FLOW_DES_OP_OUT_BUFF_NOT_MOD_8_ERROR        (CRYS_FLOW_MODULE_ERROR_BASE + 0x14UL)

/* get result operation input validity check */
#define CRYS_FLOW_ADDBUFFER_NO_ACTIVE_FLOWID_ERROR      (CRYS_FLOW_MODULE_ERROR_BASE + 0x15UL)




/************************ Enums ********************************/


/************************ Typedefs  ****************************/


/************************ Structs  ******************************/


/************************ Public Variables **********************/


/************************ Public Functions **********************/

#ifdef __cplusplus
}
#endif

#endif


